/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.monitor.config;

import com.ibm.hwmca.base.monitor.config.MonitorActionConfig;
import com.ibm.hwmca.base.monitor.config.MonitorActionTypeConfig;
import com.ibm.hwmca.base.monitor.config.MonitorConditionConfig;
import com.ibm.hwmca.base.monitor.config.MonitorConfig;
import com.ibm.hwmca.base.monitor.config.MonitorGroupConfig;
import com.ibm.hwmca.base.monitor.config.MonitorsConfig;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class MonitorConfigParser
extends DOMParser
implements ErrorHandler {
    private static final String TRACE_MASKD = "XMONMCPD";
    private static final String TRACE_MASKF = "XMONMCPF";
    private static final String TRACE_MASKT = "XMONMCPT";
    private static final String MONITORS_ELEMENT = "MONITORS";
    private static final String ACTION_TYPE_ELEMENT = "ACTION_TYPE";
    private static final String MONITOR_GROUP_ELEMENT = "MONITOR_GROUP";
    private static final String MONITOR_ELEMENT = "MONITOR";
    private static final String CONDITION_ELEMENT = "CONDITION";
    private static final String ACTION_ELEMENT = "ACTION";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String MAX_SUCCESSES_ATTRIBUTE = "maxSuccesses";
    private static final String EVERY_X_MINUTES_ATTRIBUTE = "everyXMinutes";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String MARK_ATTRIBUTE = "mark";
    private static final String ARG_ATTRIBUTE = "arg";
    private String xMLFileName = null;

    public MonitorConfigParser(String xMLFileName) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setErrorHandler(this);
        this.xMLFileName = xMLFileName;
        Trace.trace(TRACE_MASKT, "<->MonitorConfigParser(" + xMLFileName + ")");
    }

    public static void main(String[] args) {
        MonitorsConfig monitorsConfig = null;
        try {
            StringBuffer argsLine = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                argsLine.append(' ');
                argsLine.append(args[i]);
            }
            Trace.trace(TRACE_MASKT, "main() called with the following parameters :" + argsLine.toString());
            if (args.length != 1) {
                System.exit(-1);
            }
            monitorsConfig = new MonitorConfigParser(args[0]).parseXML();
            System.out.println(monitorsConfig);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public MonitorsConfig parseXML() throws IOException, SAXException, MalformedXMLException {
        MonitorsConfig result = null;
        Document document = null;
        NodeList children = null;
        Node child = null;
        boolean singleMonitorsTag = false;
        Trace.trace(TRACE_MASKT, "->parseXML()");
        this.parse(new InputSource(new FileReader(this.xMLFileName)));
        document = this.getDocument();
        if (document != null) {
            children = document.getElementsByTagName(MONITORS_ELEMENT);
            if (children != null) {
                switch (children.getLength()) {
                    case 1: {
                        child = children.item(0);
                        Trace.trace(TRACE_MASKD, "Element found from top is " + child);
                        singleMonitorsTag = true;
                        break;
                    }
                    case 0: {
                        Trace.trace(TRACE_MASKD, "No MONITORS element found from the top.");
                        break;
                    }
                    default: {
                        Trace.trace(TRACE_MASKD, "More than one MONITORS element found from the top.");
                        break;
                    }
                }
            } else {
                Trace.trace(TRACE_MASKD, "No MONITORS element found from the top.");
            }
        }
        if (!singleMonitorsTag) {
            throw new MalformedXMLException("A single <MONITORS> is expected.");
        }
        result = this.parseMonitors(child);
        Trace.trace(TRACE_MASKT, "<-parseXML() returning : " + result);
        return result;
    }

    public MonitorsConfig parseMonitors(Node node) throws IllegalArgumentException, MalformedXMLException {
        MonitorsConfig result = null;
        HashMap<String, MonitorActionTypeConfig> actionTypes = null;
        ArrayList<MonitorGroupConfig> monitorGroups = null;
        NodeList children = null;
        Node child = null;
        String curElement = null;
        MonitorActionTypeConfig monitorActionTypeConfig = null;
        MonitorGroupConfig monitorGroupConfig = null;
        String text = null;
        Trace.trace(TRACE_MASKT, "->parseTasks( " + node + ")");
        if (node != null) {
            int i;
            children = node.getChildNodes();
            for (i = 0; i < children.getLength(); ++i) {
                child = children.item(i);
                Trace.trace(TRACE_MASKD, "Child node found of " + child);
                if (child.getNodeType() != 1 || !ACTION_TYPE_ELEMENT.equals(curElement = child.getNodeName())) continue;
                monitorActionTypeConfig = this.parseActionType(child);
                if (actionTypes == null) {
                    actionTypes = new HashMap<String, MonitorActionTypeConfig>();
                }
                actionTypes.put(monitorActionTypeConfig.getName(), monitorActionTypeConfig);
            }
            if (actionTypes == null) {
                throw new MalformedXMLException("No valid ACTION_TYPE element under the MONITORS element.");
            }
            for (i = 0; i < children.getLength(); ++i) {
                child = children.item(i);
                Trace.trace(TRACE_MASKD, "Child node found of " + child);
                if (child.getNodeType() == 1) {
                    curElement = child.getNodeName();
                    if (ACTION_TYPE_ELEMENT.equals(curElement)) continue;
                    if (MONITOR_GROUP_ELEMENT.equals(curElement)) {
                        monitorGroupConfig = this.parseMonitorGroup(child, actionTypes);
                        if (monitorGroups == null) {
                            monitorGroups = new ArrayList<MonitorGroupConfig>();
                        }
                        monitorGroups.add(monitorGroupConfig);
                        continue;
                    }
                    throw new MalformedXMLException("Unexpected element " + curElement + " under the " + MONITORS_ELEMENT + " element");
                }
                if (child.getNodeType() == 3) {
                    text = child.getNodeValue();
                    if (text == null || text.trim().length() <= 0) continue;
                    throw new MalformedXMLException("No text, other than whitespace, is allowed in the MONITORS element.");
                }
                throw new MalformedXMLException("Only elements are expected under the MONITORS element.");
            }
            if (monitorGroups == null) {
                throw new MalformedXMLException("No valid MONITOR_GROUP element under the MONITORS element.");
            }
        } else {
            throw new IllegalArgumentException("node is specified as null");
        }
        result = new MonitorsConfig(actionTypes, monitorGroups);
        Trace.trace(TRACE_MASKT, "<-parseMonitors(...) returning : " + result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MonitorGroupConfig parseMonitorGroup(Node node, HashMap actionTypes) throws IllegalArgumentException, MalformedXMLException {
        MonitorGroupConfig result = null;
        ArrayList<MonitorConfig> monitors = null;
        int everyXMinutes = 0;
        NodeList children = null;
        Node child = null;
        String curElement = null;
        MonitorConfig monitorConfig = null;
        String text = null;
        NamedNodeMap attributes = null;
        Node everyXMinutesAttribute = null;
        Trace.trace(TRACE_MASKT, "->parseMonitorGroup( " + node + ")");
        if (node == null) throw new IllegalArgumentException("node is specified as null");
        children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            Trace.trace(TRACE_MASKD, "Child node found of " + child);
            if (child.getNodeType() == 1) {
                curElement = child.getNodeName();
                if (!MONITOR_ELEMENT.equals(curElement)) throw new MalformedXMLException("Unexpected element " + curElement + " under the " + MONITOR_GROUP_ELEMENT + " element");
                monitorConfig = this.parseMonitor(child, actionTypes);
                if (monitors == null) {
                    monitors = new ArrayList<MonitorConfig>();
                }
                monitors.add(monitorConfig);
                continue;
            }
            if (child.getNodeType() != 3) throw new MalformedXMLException("Only elements are expected under the MONITOR_GROUP element.");
            text = child.getNodeValue();
            if (text == null || text.trim().length() <= 0) continue;
            throw new MalformedXMLException("No text, other than whitespace, is allowed in the MONITOR_GROUP element.");
        }
        if (monitors == null) {
            throw new MalformedXMLException("No valid MONITOR element under the MONITOR_GROUP element.");
        }
        attributes = node.getAttributes();
        if (attributes == null) throw new IllegalArgumentException("No attributes specified on the MONITOR_GROUP.");
        everyXMinutesAttribute = attributes.getNamedItem(EVERY_X_MINUTES_ATTRIBUTE);
        if (everyXMinutesAttribute == null) throw new MalformedXMLException("A everyXMinutes attribute is required on the MONITOR_GROUP element.");
        try {
            everyXMinutes = Integer.parseInt(everyXMinutesAttribute.getNodeValue());
        }
        catch (NumberFormatException e) {
            throw new MalformedXMLException("The value for the everyXMinutes attribute on the MONITOR_GROUP element is not a valid number: " + everyXMinutesAttribute.getNodeValue());
        }
        result = new MonitorGroupConfig(everyXMinutes, monitors);
        Trace.trace(TRACE_MASKT, "<-parseMonitorGroup(...) returning : " + result);
        return result;
    }

    public MonitorConfig parseMonitor(Node node, HashMap actionTypes) throws IllegalArgumentException, MalformedXMLException {
        MonitorConfig result = null;
        ArrayList<MonitorConditionConfig> conditions = null;
        ArrayList<MonitorActionConfig> actions = null;
        NodeList children = null;
        Node child = null;
        String curElement = null;
        MonitorConditionConfig conditionConfig = null;
        MonitorActionConfig actionConfig = null;
        String text = null;
        Trace.trace(TRACE_MASKT, "->parseMonitor( " + node + ")");
        if (node != null) {
            children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                child = children.item(i);
                Trace.trace(TRACE_MASKD, "Child node found of " + child);
                if (child.getNodeType() == 1) {
                    curElement = child.getNodeName();
                    if (CONDITION_ELEMENT.equals(curElement)) {
                        conditionConfig = this.parseCondition(child);
                        if (conditions == null) {
                            conditions = new ArrayList<MonitorConditionConfig>();
                        }
                        conditions.add(conditionConfig);
                        continue;
                    }
                    if (ACTION_ELEMENT.equals(curElement)) {
                        actionConfig = this.parseAction(child, actionTypes);
                        if (actions == null) {
                            actions = new ArrayList<MonitorActionConfig>();
                        }
                        actions.add(actionConfig);
                        continue;
                    }
                    throw new MalformedXMLException("Unexpected element " + curElement + " under the " + MONITOR_ELEMENT + " element");
                }
                if (child.getNodeType() == 3) {
                    text = child.getNodeValue();
                    if (text == null || text.trim().length() <= 0) continue;
                    throw new MalformedXMLException("No text, other than whitespace, is allowed in the MONITOR element.");
                }
                throw new MalformedXMLException("Only elements are expected under the MONITOR element.");
            }
            if (conditions == null) {
                throw new MalformedXMLException("No valid CONDITION element under the MONITOR element.");
            }
            if (actions == null) {
                throw new MalformedXMLException("No valid ACTION element under the MONITOR element.");
            }
        } else {
            throw new IllegalArgumentException("node is specified as null");
        }
        result = new MonitorConfig(conditions, actions);
        Trace.trace(TRACE_MASKT, "<-parseMonitor(...) returning : " + result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MonitorActionTypeConfig parseActionType(Node node) throws IllegalArgumentException, MalformedXMLException {
        MonitorActionTypeConfig result = null;
        NodeList children = null;
        NamedNodeMap attributes = null;
        Node classAttribute = null;
        Node nameAttribute = null;
        Node maxSuccessesAttribute = null;
        String className = null;
        String name = null;
        int maxSuccesses = 0;
        Trace.trace(TRACE_MASKT, "->parseActionType( " + node + ")");
        if (node == null) throw new IllegalArgumentException("node is specified as null");
        children = node.getChildNodes();
        if (children.getLength() != 0) throw new MalformedXMLException("There are elements under the ACTION_TYPE element and this is unexpected.");
        attributes = node.getAttributes();
        if (attributes == null) throw new IllegalArgumentException("No attributes specified on the ACTION_TYPE.");
        nameAttribute = attributes.getNamedItem(NAME_ATTRIBUTE);
        if (nameAttribute == null) {
            throw new MalformedXMLException("A name attribute is required on the ACTION_TYPE element.");
        }
        name = nameAttribute.getNodeValue();
        classAttribute = attributes.getNamedItem(CLASS_ATTRIBUTE);
        if (classAttribute == null) {
            throw new MalformedXMLException("A class attribute is required on the ACTION_TYPE element.");
        }
        className = classAttribute.getNodeValue();
        maxSuccesses = Integer.MAX_VALUE;
        maxSuccessesAttribute = attributes.getNamedItem(MAX_SUCCESSES_ATTRIBUTE);
        if (maxSuccessesAttribute != null) {
            try {
                maxSuccesses = Integer.parseInt(maxSuccessesAttribute.getNodeValue());
            }
            catch (NumberFormatException e) {
                throw new MalformedXMLException("The value for the maxSuccesses attribute on the ACTION_TYPE element is not a valid number: " + maxSuccessesAttribute.getNodeValue());
            }
        }
        result = new MonitorActionTypeConfig(name, className, maxSuccesses);
        Trace.trace(TRACE_MASKT, "<-parseActionType(...) returning : " + result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MonitorConditionConfig parseCondition(Node node) throws IllegalArgumentException, MalformedXMLException {
        MonitorConditionConfig result = null;
        NodeList children = null;
        NamedNodeMap attributes = null;
        Node classAttribute = null;
        Node argAttribute = null;
        String className = null;
        String arg = null;
        Trace.trace(TRACE_MASKT, "->parseCondition( " + node + ")");
        if (node == null) throw new IllegalArgumentException("node is specified as null");
        children = node.getChildNodes();
        if (children.getLength() != 0) throw new MalformedXMLException("There are elements under the CONDITION element and this is unexpected.");
        attributes = node.getAttributes();
        if (attributes == null) throw new IllegalArgumentException("No attributes specified on the CONDITION.");
        classAttribute = attributes.getNamedItem(CLASS_ATTRIBUTE);
        if (classAttribute == null) {
            throw new MalformedXMLException("A class attribute is required on the CONDITION element.");
        }
        className = classAttribute.getNodeValue();
        argAttribute = attributes.getNamedItem(ARG_ATTRIBUTE);
        if (argAttribute != null) {
            arg = argAttribute.getNodeValue();
        }
        result = new MonitorConditionConfig(className, arg);
        Trace.trace(TRACE_MASKT, "<-parseCondition(...) returning : " + result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MonitorActionConfig parseAction(Node node, HashMap actionTypes) throws IllegalArgumentException, MalformedXMLException {
        MonitorActionConfig result = null;
        MonitorActionTypeConfig actionTypeConfig = null;
        NodeList children = null;
        NamedNodeMap attributes = null;
        Node typeAttribute = null;
        Node markAttribute = null;
        Node argAttribute = null;
        String type = null;
        String mark = null;
        String arg = null;
        Trace.trace(TRACE_MASKT, "->parseAction( " + node + ")");
        if (node == null) throw new IllegalArgumentException("node is specified as null");
        children = node.getChildNodes();
        if (children.getLength() != 0) throw new MalformedXMLException("There are elements under the ACTION element and this is unexpected.");
        attributes = node.getAttributes();
        if (attributes == null) throw new IllegalArgumentException("No attributes specified on the ACTION.");
        typeAttribute = attributes.getNamedItem(TYPE_ATTRIBUTE);
        if (typeAttribute == null) throw new MalformedXMLException("A type attribute is required on the ACTION element.");
        type = typeAttribute.getNodeValue();
        actionTypeConfig = (MonitorActionTypeConfig)actionTypes.get(type);
        if (actionTypeConfig == null) {
            throw new MalformedXMLException("The type attribute on the ACTION element is not found as the name attribute on any ACTION_TYPE element : " + type);
        }
        argAttribute = attributes.getNamedItem(ARG_ATTRIBUTE);
        if (argAttribute != null) {
            arg = argAttribute.getNodeValue();
        }
        if ((markAttribute = attributes.getNamedItem(MARK_ATTRIBUTE)) != null) {
            mark = markAttribute.getNodeValue();
        }
        result = new MonitorActionConfig(actionTypeConfig, arg, mark);
        Trace.trace(TRACE_MASKT, "<-parseAction(...) returning : " + result);
        return result;
    }

    public void warning(SAXParseException saxPE) {
        Trace.trace(TRACE_MASKF, "XML parsing WARNING : " + CommonXMLParser.where(saxPE));
    }

    public void error(SAXParseException saxPE) throws SAXException {
        Trace.trace(TRACE_MASKF, "XML parsing ERROR: " + CommonXMLParser.where(saxPE));
        throw saxPE;
    }

    public void fatalError(SAXParseException saxPE) throws SAXException {
        Trace.trace(TRACE_MASKF, "XML parsing FATAL: " + CommonXMLParser.where(saxPE));
        throw saxPE;
    }
}

